package kochModel;
import java.awt.*;
import fp.*;



/**
 * This is the base case state for the Koch curve.   This state is graphically represented as a straight line.
 */
class BaseState extends AKochState {
  
  public <R,P> R execute(Koch host, IKochVisitor<R,P> algo, P...param) {
    return algo.baseCase(host, param);
  }
  
  public <R,P> R fold(Koch host, IFoldAlgo<Koch,R,P> algo, R base, P... param) {
    return base;
  }
  
}

